/*     Tento kd ukazuje jak v OpenGL pout matice
       k uren souadnic bodu v protsoru snad nkomu 
       pome, jinak je samozejm en pod GPL
                            Pemysl Jaro 2003 
       
       Uprosted obrazovky vykreslujeme rotujc kostku
       vpravo nahoe vypisuji pozice jejch tr vrchl 
       v prostoru. 

       Pedem chci upozornit e kd nen dokonal
       asi nejvt trhlynou je e nen obecn 
       v ppad e budete chtt ve sv aplikaci 
       pout matice budete si napsat svj kd 
       scela od zatku*/


/* Nejd vlome klasick hlaviky pro Opengl
   SDL a nkter dal*/
#include <stdio.h>
#include<sdl_opengl.h>//vkld za ns OpenGL
#include "SDL.h" // Hlavikov soubor pro SDL
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <SDL_image.h>// Abychom mohli pouvat funkci IMG_Load() nate texturu textu
#include <math.h>

/*Definujeme njak promn nejduleitj je pole m*/
GLdouble m[16];// Pam pro modelview matici 

/*tyto promn nejsou dleit k tmatu*/ 
GLuint base;// Ukazatel na prvn z display list pro font
GLuint loop;// Pomocn pro cykly

float xrot, yrot, zrot;//informace o hlu otoen
GLuint gl_texture;// Ukld texturu

float x,y,z;/* pomocn promn pi vpotech vrchl ukldaj se 
              pouze doasn hodnoty*/ 

/* Zde mme nejduleitj funkci programu pebr ti argumenty co 
   jsou hodnoty jednoho bodu jeho pozici chceme urit k tomu vyuijeme
   matici kterou mme uloenou v poli m, vsledek ukld do pomocnch 
   promnch*/
void Matrix(float vx,float vy,float vz)
{
  x =(float)( vx * m[0] + vy * m[4] + vz * m[8] +m[12]);

  y =(float)( vx * m[1] + vy * m[5] + vz * m[9] +m[13]);

  z =(float)( vx * m[2] + vy * m[6] + vz * m[10] +m[14]);
}

/* Funkce k vytvoen font pevzata z NeHe tutorilu 17*/
GLvoid BuildFont(GLvoid)// Vytvoen display list fontu
{
   float cx;// Koordinty x
   float cy;// Koordinty y

   base=glGenLists(256);// 256 display list
   glBindTexture(GL_TEXTURE_2D, gl_texture);// Vbr textury
   for (loop=0; loop<256; loop++)// Vytv 256 display list
   {
      cx=float(loop%16)/16.0f;// X pozice aktulnho znaku
      cy=float(loop/16)/16.0f;// Y pozice aktulnho znaku

      glNewList(base+loop,GL_COMPILE);// Vytvoen display listu
      glBegin(GL_QUADS);// Pro kad znak jeden obdlnk
      glTexCoord2f(cx,1-cy-0.0625f); glVertex2i(0,0);// Lev doln
      glTexCoord2f(cx+0.0625f,1-cy-0.0625f); glVertex2i(16,0);// Prav doln
      glTexCoord2f(cx+0.0625f,1-cy); glVertex2i(16,16);// Prav horn
      glTexCoord2f(cx,1-cy); glVertex2i(0,16);// Lev horn
      glEnd();// Konec znaku

      glTranslated(10,0,0);// Pesun na pravou stranu znaku
      glEndList();// Konec kreslen display listu
      }// Cyklus pokrauje dokud se nevytvo vech 256 znak
}

/*Funkce sloc k naten textury fontu pevzata z turilu 
  o SDL_image od Bernyho*/
SDL_Surface* LoadBitmap(const char *filename)// Funkce pro nateni bitmapy
{
   Uint8 *rowhi, *rowlo;// Ukazatele na prohazovni dk
   Uint8 *tmpbuf, tmpch;// Doasn pam
   int i, j;// dc promnn pro cykly

   SDL_Surface *image;// Natan obrzek

   image = IMG_Load(filename);// Naten dat obrzku

   if (image == NULL)// Oeten chyby pi natn
   {
      fprintf(stderr, "Nepodarilo se nacist %s: %s\n", filename, SDL_GetError());
      return(NULL);
   }

   tmpbuf = (Uint8 *)malloc(image->pitch);// Alokace pamti

   if (tmpbuf == NULL)// Oeten chyby
   {
      fprintf(stderr, "Nedostatek pameti\n");
      return NULL;
   }

   // Nastaven prvnho a poslednho dku
   rowhi = (Uint8 *)image->pixels;
   rowlo = rowhi + (image->h * image->pitch) - image->pitch;

   for (i = 0; i < image->h/2; i++)
   {
     // Pevrcen BGR na RGB
     if (image->format->Bshift == 0)
     {
        for (j = 0; j < image->w; j++)
        {
           tmpch = rowhi[j*3];
           rowhi[j*3] = rowhi[j*3+2];
           rowhi[j*3+2] = tmpch;
           tmpch = rowlo[j*3];
           rowlo[j*3] = rowlo[j*3+2];
           rowlo[j*3+2] = tmpch;
        }
     }

     // Prohozen dk
     memcpy(tmpbuf, rowhi, image->pitch);
     memcpy(rowhi, rowlo, image->pitch);
     memcpy(rowlo, tmpbuf, image->pitch);

     // Posun ukazatel na dky
     rowhi += image->pitch;
     rowlo -= image->pitch;
  }

  free(tmpbuf);// klid
  return image;// Vrt naten obrzek
}

/*Funkce vytvoc font opt pevzata z lnku od Bernyho*/
GLuint CreateTexture(const char *file, int min_filter, int mag_filter, bool mipmaps)// Vytvo texturu
{
   SDL_Surface *surface;// Obrzek
   
   surface = LoadBitmap(file);// Naten obrzku

   if (surface == NULL)// Oeten chyby
       return 0;

   GLuint texture;// OpenGL textura
   glGenTextures(1, &texture);// Generovn jedn textury
   glBindTexture(GL_TEXTURE_2D, texture);// Nastaven textury
   // Nastaven poadovanch filtr
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, mag_filter);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, min_filter);
   if (mipmaps)// Mipmapovan textura
   {
      gluBuild2DMipmaps(GL_TEXTURE_2D, 3, surface->w, surface->h, GL_RGB, GL_UNSIGNED_BYTE, surface->pixels);
   }
   else// Obyejn textura
   {
      glTexImage2D(GL_TEXTURE_2D, 0, 3, surface->w, surface->h, 0, GL_RGB, GL_UNSIGNED_BYTE, surface->pixels);
   }

   SDL_FreeSurface(surface);// Smazn SDL_Surface
   surface = NULL;// Nastaven ukazatele na NULL
   return texture;// Vrt texturu
}


/*Zde inicializujeme OpenGL*/
void InitGL(int Width, int Height) // Tuto funkci volme hned po vytvoen okna pro inicializace OpenGL
{
  glViewport(0, 0, Width, Height);//nastaven wieportu 
  glClearColor(0.0f, 0.0f, 0.0f, 0.0f); // ern pozad
  glClearDepth(1.0); // Povolme mazn pozad
  glDepthFunc(GL_LESS); // Vybereme typ Depth Testu
  glEnable(GL_DEPTH_TEST); // Povolme Depth Test
  glShadeModel(GL_SMOOTH); // Povolme Smooth Color Shading
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity(); // Resetujeme projekn matici
  gluPerspective(45.0f,(GLfloat)Width/(GLfloat)Height,0.1f,100.0f); // Vypotme pomr okna
  glMatrixMode(GL_MODELVIEW);
  xrot = yrot = zrot = 0.0; //inicializujeme pomocn promn ale je to pomrn zbiten 
  glDisable(GL_TEXTURE_2D);// Povolen mapovn textur
  if ((gl_texture = CreateTexture("data/Font.jpg", GL_LINEAR, GL_LINEAR, false)) == 0)//nateme font
  {
     fprintf(stderr, "Nepodarilo se vytvorit texturu\n");
     exit(1);
  }
  BuildFont();// Vytvo font
  glBlendFunc(GL_SRC_ALPHA,GL_ONE);// Vybere typ blendingu
}

/*Funkce slouc k vpisu textu opt pevzato z NeHe tut.17*/
GLvoid glPrint(GLint x, GLint y, int set, const char *fmt, ...)// Vpis text
{
   char text[256];// Bude ukldat vsledn etzec
   va_list ap;// Ukazatel do argument funkce

   if (fmt == NULL)// Nebyl pedn etzec
      return;// Konec

   va_start(ap, fmt);// Rozdl etzec pro promnn
   vsprintf(text, fmt, ap);// Konvertuje symboly na sla
   va_end(ap);// Vsledek je uloen v text
 
   if (set>1)// Byla pedna patn znakov sada?
   {
      set=1;// Pokud ano, zvol se kurzva
   }
   
    glDisable(GL_DEPTH_TEST);// Vypne hloubkov testovn
    glMatrixMode(GL_PROJECTION);// Vybere projekn matici
    glPushMatrix();// Ulo projekn matici
    glLoadIdentity();// Reset matice
    glOrtho(0,640,0,480,-1,1);// Nastaven kolm projekce
    glMatrixMode(GL_MODELVIEW);// Vbr matice
    glPushMatrix();// Uloen matice
    glLoadIdentity();// Reset matice
    glEnable(GL_BLEND);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, gl_texture);// Vbr textury
   glTranslated(x,y,0);// Pesun na poadovanou pozici
   glListBase(base-32+(128*set));// Zvol znakovou sadu
 
   glCallLists(strlen(text),GL_UNSIGNED_BYTE, text);// Vpis textu na monitor
    
    glDisable(GL_BLEND);
   glMatrixMode(GL_PROJECTION);// Vbr projekn matice
   glPopMatrix();// Obnoven uloen projekn matice
   glMatrixMode(GL_MODELVIEW);// Vbr matice modelview
   glPopMatrix();// Obnoven uloen modelview matice
   glEnable(GL_DEPTH_TEST);// Zapne hloubkov testovn
   glDisable(GL_TEXTURE_2D);
}

//Funkce slou k vykreslen na obrazovku
void DrawGLScene() // Hlavn vykreslovac funkce
{
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT); // Vymazn obrazovkovho a hloubkovho bufferu
  glLoadIdentity(); // Reset matice pohledu
  glTranslatef(0.0f,0.0f,-7.0f); // Posun o 1.5 doleva a o 6 do hloubky
  glRotatef(xrot,1.0,0.0,0.0);//rotace v X vektoru
  glRotatef(yrot,0.0,1.0,0.0);//rotace v Y vektoru
  glRotatef(zrot,0.0,0.0,1.0);//rotace v Z vektoru 
  //Vykreslme krychly 
  glBegin(GL_QUADS);// Zatek kreslen krychle
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f, 1.0f,-1.0f);// Prav horn bod (horn stna)
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f(-1.0f, 1.0f,-1.0f);// Lev horn bod (horn stna)
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f(-1.0f, 1.0f, 1.0f);// Lev doln bod (horn stna)
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f( 1.0f, 1.0f, 1.0f);// Prav doln bod (horn stna)
 
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f,-1.0f, 1.0f);// Prav horn bod (spodn stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f, 1.0f);// Lev horn (spodn stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f,-1.0f);// Lev doln (spodn stna)
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f( 1.0f,-1.0f,-1.0f);// Prav doln (spodn stna)
  
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f( 1.0f, 1.0f, 1.0f);// Prav horn (eln stna)
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f(-1.0f, 1.0f, 1.0f);// Lev horn (eln stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f, 1.0f);// Lev doln (eln stna)
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f,-1.0f, 1.0f);// Prav doln (eln stna)
  
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f( 1.0f,-1.0f,-1.0f);// Prav horn (zadn stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f,-1.0f);// Lev horn (zadn stna)
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f(-1.0f, 1.0f,-1.0f);// Lev doln (zadn stna)
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f, 1.0f,-1.0f);// Prav doln (zadn stna)
  
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f(-1.0f, 1.0f, 1.0f);// Prav horn (lev stna)
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f(-1.0f, 1.0f,-1.0f);// Lev horn (lev stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f,-1.0f);// Lev doln (lev stna)
  glColor3f(0.0f,0.0f,1.0f);// Modr
  glVertex3f(-1.0f,-1.0f, 1.0f);// Prav doln (lev stna)
  
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f, 1.0f,-1.0f);// Prav horn (prav stna)
  glColor3f(1.0f,0.0f,0.0f);// erven
  glVertex3f( 1.0f, 1.0f, 1.0f);// Lev horn (prav stna)
  glColor3f(0.0f,1.0f,0.0f);// zelen
  glVertex3f( 1.0f,-1.0f, 1.0f);// Lev doln (prav stna)
  glColor3f(1.0f,1.0f,0.0f);// lut
  glVertex3f( 1.0f,-1.0f,-1.0f);// Prav doln (prav stna)
  glEnd();// Konec kreslen krychle

  glGetDoublev(GL_MODELVIEW_MATRIX, m);// Zskn modelview matice kterou ulome 
                                       // v poli m 

  glPrint(5,460,0,"Matrix");//vype tma demonsrtace
  
  /*Zde postupn vypoteme a zobrazme souadnice vech bod 
    vimnte si e fci. Matrix kter ve zpot pdvm pevn hodnoty
    to by v opravdov aplikaci nelo ale zde mme jen 8 vrchol
    hodnoty vrchol znm zbv pouze urit pozici po pouit fc.
    glTranslate a glRotate k emu nm pome matic a fce. Matrix*/
  Matrix(-1.0,1.0,1.0);
  glPrint(400,460,0,"v1 %.2f %.2f %.2f",x,y,z);
  Matrix(-1.0,-1.0,1.0);
  glPrint(400,440,0,"v2 %.2f %.2f %.2f",x,y,z);
  Matrix(-1.0,1.0,-1.0);
  glPrint(400,420,0,"v3 %.2f %.2f %.2f",x,y,z);
  Matrix(-1.0,-1.0,-1.0);
  glPrint(400,400,0,"v4 %.2f %.2f %.2f",x,y,z);
  Matrix(1.0,1.0,1.0);
  glPrint(400,380,0,"v5 %.2f %.2f %.2f",x,y,z);
  Matrix(1.0,-1.0,1.0);
  glPrint(400,360,0,"v6 %.2f %.2f %.2f",x,y,z);
  Matrix(1.0,1.0,-1.0);
  glPrint(400,340,0,"v7 %.2f %.2f %.2f",x,y,z);
  Matrix(1.0,-1.0,-1.0);
  glPrint(400,320,0,"v8 %.2f %.2f %.2f",x,y,z);

  /*Zbv pouze upravit hodnoty tchto promnnch pro otoen*/
  xrot += 0.15;
  yrot -= 0.15;
  zrot += 0.15; 

  SDL_GL_SwapBuffers(); // Prohozeni bufferu, aby se zobrazilo, co jsme nakreslili
}

/*Funkce main tak pevzat od Bernyho*/
int main(int argc, char **argv) // funkce main
{
  int done; // Ukonovac promnn
  if ( SDL_Init(SDL_INIT_VIDEO) < 0 ) // Inicializace SDL s grafickm vstupem
  {
    fprintf(stderr, "Selhala inicializace SDL: %s\n", SDL_GetError());
    exit(1);
  }
  if (SDL_SetVideoMode(640, 480, 0, SDL_OPENGL) == NULL) // Vytvoen OpenGL okna 640x480
  {
    fprintf(stderr, "Neni mozne vytvorit OpenGL okno: %s\n", SDL_GetError());
    SDL_Quit(); // Ukonen SDL
    exit(2);
  }
 
  SDL_WM_SetCaption("Matrix tutorial", NULL); // Titulek okna
  InitGL(640, 480); // Inicializace OpenGL
  done = 0; // Jet nekonit
  while (!done) // Hlavn cyklus programu
  {
    DrawGLScene(); // Vykreslen scny
    SDL_Event event; // Promnn zprvy
    while (SDL_PollEvent(&event)) // Zpracovvat zprvy
    {
      if (event.type == SDL_QUIT) // Zprva o ukonen
      {
         done = 1; // Ukonit hlavn cyklus
      }
      if (event.type == SDL_KEYDOWN) // Zprva o stisku klvesy
      {
         if (event.key.keysym.sym == SDLK_ESCAPE) // Klvesa ESC
         {
            done = 1; // Ukonit hlavn cyklus
         }
      }
   }
 }
SDL_Quit(); // Ukonen SDL
return 1;
}


