/***************************************************************************
 *   basecode - archive of useful C++ classes                              *
 *   Copyright (C) 2004 by Michal Turek - Woq                              *
 *   WOQ (at) seznam.cz, http://woq.nipax.cz/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef __CCAMERAAPP_H__
#define __CCAMERAAPP_H__

#include <vector>
#include "basecode.h"
#include "capplication.h"
#include "cgrid.h"
#include "ccamera.h"
#include "cvector.h"

#define SIZE 64.0f

using namespace std;

namespace basecode
{

class CCameraApp : public CApplication
{
public:
	CCameraApp(int argc, char *argv[]);
	virtual ~CCameraApp();
	virtual void Init(const string& win_title);

protected:
	virtual void InitGL();
	virtual void OnInit();
	virtual void Draw();
	virtual void Update();
	virtual bool ProcessEvent(SDL_Event& event);

private:
	CCamera m_cam;
	vector<CVector<float> > m_bullets_pos;
	vector<CVector<float> > m_bullets_dir;
};

}

#endif
