/***************************************************************************
 *   basecode - archive of useful C++ classes                              *
 *   Copyright (C) 2004 by Michal Turek - Woq                              *
 *   WOQ (at) seznam.cz, http://woq.nipax.cz/                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "basecode.h"
#include "ccameraapp.h"

using namespace std;
using namespace basecode;

void my_terminate();
void my_unexpected();

void (*old_terminate)() = set_terminate(my_terminate);
void (*old_unexpected)() = set_unexpected(my_unexpected);

void my_terminate()
{
	cerr << _("Uncatched exception or throwing exception in destructor!")
			<< endl;
	old_terminate();
}

void my_unexpected()
{
	cerr << _("Unexpected exception was thrown!") << endl;
	old_unexpected();
}

// Tak tohle jsem resil pul hodky, debilni "wokenni standardy"!!!
// int main(int argc, char *argv[])

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
           LPSTR lpCmdLine, int nCmdShow)
{
	try
	{
		CCameraApp app(0, NULL);
		app.Init(_("camera"));
		app.MainLoop();
	}
	catch(CFileNotFound& ex)
	{
		cerr << _("File was not found: ") << ex.what() << endl;
		return EXIT_FAILURE;
	}
	catch(CBadFileFormat& ex)
	{
		cerr << _("Bad file format: ") << ex.what() << endl;
		return EXIT_FAILURE;
	}
	catch(std::bad_alloc& ex)
	{
		cerr << _("Unable to allocate memory: ")
				<< ex.what() << endl;
		return EXIT_FAILURE;
	}
	catch(std::runtime_error& ex)
	{
		cerr << ex.what() << endl;
		return EXIT_FAILURE;
	}
	catch(...)
	{
		cerr << _("Unhandled exception occurs!") << endl;
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}
