/*
 *	primka2d.cpp - Implementan soubor tdy WPrimka2D
 *
 *	Michal Turek - Woq, 30.1.2004
 *
 *	woq@email.cz
 *	http://woq.nipax.cz/
 *	http://nehe.opengl.cz/
 *
 *	Kd je voln iiteln podle licence GNU GPL (http://www.gnu.cz/), pouit absolutn bez zruky.
 *
 */

#include "primka2d.h"

WPrimka2D::WPrimka2D()
{
	a = 0.0;
	b = 0.0;
	c = 0.0;
}

WPrimka2D::~WPrimka2D()
{

}

WPrimka2D::WPrimka2D(const WPrimka2D& primka)
{
	a = primka.a;
	b = primka.b;
	c = primka.c;
}

WPrimka2D::WPrimka2D(double a, double b, double c)
{
	Create(a, b, c);
}

WPrimka2D::WPrimka2D(double x1, double y1, double x2, double y2)
{
	Create(x1, y1, x2, y2);
}

void WPrimka2D::Create(double a, double b, double c)
{
	this->a = a;
	this->b = b;
	this->c = c;
}

void WPrimka2D::Create(double x1, double y1, double x2, double y2)
{
	if(x1 == x2 && y1 == y2)// 2 stejn body
	{
		Create(0.0, 0.0, 0.0);// Platn hodnoty
		return;
	}

	a = y2 - y1;
	b = x1 - x2;
	c = - a*x1 - b*y1;
}

bool WPrimka2D::operator==(WPrimka2D& primka)
{
	double ka = a / primka.a;// Nesta pouze zkontrolovat hodnoty, primka me bt k-nsobkem
	double kb = b / primka.b;
	double kc = c / primka.c;

	if(ka == kb && ka == kc)// Mus bt stejn
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool WPrimka2D::operator!=(WPrimka2D& primka)
{
	return !(*this == primka);
}

bool WPrimka2D::JeNaPrimce(double x, double y)
{
	if(a*x + b*y + c == 0.0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool WPrimka2D::JsouRovnobezne(WPrimka2D& primka)
{
	double ka = a / primka.a;// Nesta zkontrolovat hodnoty, p me bt k-nsobkem
	double kb = b / primka.b;

	if(ka == kb)// Mus bt stejn
	{
		return true;
	}
	else
	{
		return false;
	}
}

bool WPrimka2D::JsouKolme(WPrimka2D& primka)
{
	WPrimka2D pom(-primka.b, primka.a, primka.c);// Pmka s kolmm vektorem

	return JsouRovnobezne(pom);
}

bool WPrimka2D::Prusecik(WPrimka2D& primka, double& retx, double& rety)
{
	if(*this == primka)// Pmky jsou splvajc - nekonen mnoho spolench bod
	{
		return false;// Sp by se mlo vrtit true a njak bod... zle na pouit
	}
	else if(JsouRovnobezne(primka))// Pmky jsou rovnobn - dn spolen bod
	{
		return false;
	}
	else// Jeden spolen bod - prsek (vyhovuje souasn obma rovnicm
	{
		retx = (b*primka.c - c * primka.b) / (a*primka.b - primka.a*b);
		rety = -(a*primka.c - primka.a * c) / (a*primka.b -  primka.a*b);

		return true;
	}
}

double WPrimka2D::Uhel(WPrimka2D& primka)
{
	return acos((a*primka.a + b*primka.b) / (sqrt(a*a + b*b) * sqrt(primka.a*primka.a + primka.b*primka.b)));
}

double WPrimka2D::VzdalenostBodu(double x, double y)
{
	double vzdalenost = (a*x + b*y + c) / sqrt(a*a + b*b);

	if(vzdalenost < 0.0)// Absolutn hodnota
	{
		vzdalenost = -vzdalenost;
	}

	return vzdalenost;
}

