/*
 *	primka2d.h - Hlavikov soubor pmky WPrimka2D
 *
 *	Michal Turek - Woq, 30.1.2004
 *
 *	woq@email.cz
 *	http://woq.nipax.cz/
 *	http://nehe.opengl.cz/
 *
 *	Kd je voln iiteln podle licence GNU GPL (http://www.gnu.cz/), pouit absolutn bez zruky.
 *
 */

 
#ifndef __PRIMKA2D_H__
#define __PRIMKA2D_H__

#include <math.h>

class WPrimka2D// Tda 2D pmky
{
private:
	double a, b, c;// Obecn rovnice pmky a*x + b*y + c = 0

public:
	WPrimka2D();
	~WPrimka2D();
	WPrimka2D(const WPrimka2D& primka);
	WPrimka2D(double a, double b, double c);// Pm zadn
	WPrimka2D(double x1, double y1, double x2, double y2);// Pmka ze dvou bod

	void Create(double a, double b, double c);
	void Create(double x1, double y1, double x2, double y2);

	inline double GetA() { return a; }
	inline double GetB() { return b; }
	inline double GetC() { return b; }

	bool operator==(WPrimka2D& primka);// Jsou pmky splvajc? V vahu se berou i k-nsobky.
	bool operator!=(WPrimka2D& primka);// Negace...

	bool JeNaPrimce(double x, double y);// Le bod na pmce?
	bool JsouRovnobezne(WPrimka2D& primka);// Jsou pmky rovnobn?
	bool JsouKolme(WPrimka2D& primka);// Jsou pmky kolm?

	bool Prusecik(WPrimka2D& primka, double& retx, double& rety);// Prsek dvou pmek, false pokud neexistuje (rovnobn)
	double Uhel(WPrimka2D& primka);// hel dvou pmek (v radinech)
	double VzdalenostBodu(double x, double y);// Vzdlenost bodu od pmky
};

#endif
